%------------------------------------------------------------------------------
% File     : SEU475^1 : TPTP v7.4.0. Bugfixed v3.7.0.
% Domain   : Set Theory (Binary relations)
% Problem  : Not swapping symmetric closure and transitive closure
% Version  : [Nei08] axioms.
% English  : Taking the symmetric closure of the transitive closure is NOT the
%            same as taking the transitive closure of the symmetric closure.

% Refs     : [BN99]  Baader & Nipkow (1999), Term Rewriting and All That
%          : [Nei08] Neis (2008), Email to Geoff Sutcliffe
% Source   : [Nei08]
% Names    :

% Status   : Theorem
% Rating   : 0.86 v7.4.0, 0.89 v7.2.0, 0.88 v7.0.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   60 (   0 unit;  29 type;  29 defn)
%            Number of atoms       :  265 (  37 equality; 166 variable)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :  168 (   8   ~;   4   |;  14   &; 126   @)
%                                         (   0 <=>;  16  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  199 ( 199   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   31 (  29   :;   0   =)
%            Number of variables   :   90 (   0 sgn;  39   !;   8   ?;  43   ^)
%                                         (  90   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Some proofs can be found in chapter 2 of [BN99]
%          : 
% Bugfixes : v3.7.0 - Added extra hypothesis three_individuals
%------------------------------------------------------------------------------
%----Include axioms of binary relations
include('Axioms/SET009^0.ax').
%------------------------------------------------------------------------------
thf(three_individuals,hypothesis,(
    ? [X: $i,Y: $i,Z: $i] :
      ( ( X != Y )
      & ( X != Z )
      & ( Y != Z ) ) )).

thf(composing_symmetric_closure_and_transitive_closure,conjecture,(
    ~ ( ! [R: $i > $i > $o] :
          ( ( sc @ ( tc @ R ) )
          = ( tc @ ( sc @ R ) ) ) ) )).

%------------------------------------------------------------------------------
